/* Radiation Vector display for general plotting (esp lgp) */
/* cc -O lrv.c -lplot -lfrm -lm -o lrv */
#include <stdio.h>
#include <math.h>
#include <carl/frm.h>

#define XMIN 0
#define XMAX 720
#define XMAX 1799
#define YMIN 0
#define YMAX 720
#define YMAX 1799
#define PI2 (8.*atan(1.))
#define PI (4.*atan(1.))
#define USAGE\
{\
fprintf(stderr, "\nLRV Usage:\n");\
fprintf(stderr, " lrv\n");\
fprintf(stderr, "	[\n");\
fprintf(stderr, "	-Ttheta (in degrees [315])\n");\
fprintf(stderr, "	-Bback [.1]\n");\
fprintf(stderr, "	-Lstring [none]\n");\
fprintf(stderr, "	]\n");\
exit(-1);\
}

/* current screen coordinates */
double sxmin= 0., sxmax= 1., 
      symin= 1., symax= 0.;
/* locate current window within screen coordinates */
double wxmin= 0., wxmax= 1.,
      wymin= 0., wymax= 1.;
/* current plot range coordinates */
double rxmin= -1.2, rxmax= 1.2,
      rymin= 1.2, rymax= -1.2;

main(argc, argv) int argc; char *argv[];
{
 double r, dt, phi, theta = 315., back = .1;
 int i, n;
 char s[100];
 int lstring;

    for(i = 1; i < argc; i++){
	if(*argv[i] != '-')USAGE;
	switch(*(++argv[i])){
	    case 'T': theta = expr(++argv[i]); break;
	    case 'B': back = expr(++argv[i]); break;
	    case 'L': lstring = i; break;
	}
    }
    openpl();
    erase();
    windowbox();
    quadrants();
    move( px(-1.1), py(1.1));
    if(!lstring)
     sprintf(s,"Radiation vector for Theta = %.0f degrees, Back = %.3f",
	theta, back);
     label(s);
    theta = theta*PI2/360.; /* convert to radians */
    back = sqrt(back);
    move(px(0.), py(0.));
    cont(px(cos(theta)), py(sin(theta)));
    circle(px(cos(theta)), py(sin(theta)), 5);
    for(phi=0.; phi<=PI2+.1; phi += PI2/512.){
	dt = fabs(theta - phi);
	if(dt > PI)dt = PI2 - dt;
	r = 1 + (back - 1)*dt/PI;
	r *= r;
	if(phi)cont( px(r*cos(phi)), py(r*sin(phi)) );
	else move( px(r*cos(phi)), py(r*sin(phi)) );
    }
    linemod("dotted");
    for(phi=theta + PI2/64.; phi<=theta + PI2; phi += PI2/32.){
	dt = fabs(theta - phi);
	if(dt > PI)dt = PI2 - dt;
	r = 1 + (back - 1)*dt/PI;
	r *= r;
	line( px(r*cos(phi)), py(r*sin(phi)), px(0.), py(0.) );
    }
    if(lstring){
	move( px(-1.1), py(-1.1));
	label(++argv[lstring]);
    }
    closepl();
}
windowbox(){
    move(wx(wxmin),wy(wymin));
    cont(wx(wxmax),wy(wymin));
    cont(wx(wxmax),wy(wymax));
    cont(wx(wxmin),wy(wymax));
    cont(wx(wxmin),wy(wymin));
}
quadrants(){
    move(px(rxmin),py(0.));
    cont(px(rxmax),py(0.));
    move(px(0.),py(rymin));
    cont(px(0.),py(rymax));
    move(px(1.),py(1.));
    label("I");
    move(px(-1.),py(1.));
    label("II");
    move(px(-1.),py(-1.));
    label("III");
    move(px(1.),py(-1.));
    label("IV");
}

double interp(x, xmin, xmax, omin, omax) double x, xmin, xmax, omin, omax; {
    return( (x - xmin)*(omax - omin)/(xmax - xmin) + omin );
}
sx(x) double x; { /* screen to absolute */
 double interp();
    return( (int) interp(x, sxmin, sxmax, (double) XMIN, (double) XMAX) );
}
sy(y) double y; { /* screen to absolute */
    return( (int) interp(y, symin, symax, (double) YMIN, (double) YMAX) );
}
wx(x) double x; { /* window to absolute */
    return( sx(interp(x, wxmin, wxmax, wxmin, wxmax) ) );
}
wy(y) double y; { /* window to absolute */
    return( sy(interp(y, wymin, wymax, wymin, wymax) ) );
}
px(x) double x; { /* ranged data to absolute with window within screen */
 double interp();
    return( sx( interp(x, rxmin, rxmax, wxmin, wxmax) ) );
}
py(y) double y; { /* ranged data to absolute with window within screen */
 double interp();
    return( sy( interp(y, rymin, rymax, wymin, wymax) ) );
}
