/* Power spectrum display for lgp */
/* cc -O lpsdisp.c -lplot -lfrm -lm -o lpsdisp */
#include <stdio.h>
#include <math.h>
#include <carl/frm.h>

#define XMIN 0
#define XMAX 767
#define XMAX 1799
#define YMIN 0
#define YMAX 584
#define YMAX 1799
#define INCR .0025
#define WLEN 512.
#define USAGE\
{\
fprintf(stderr, "\nLPSDISP Usage:\n");\
fprintf(stderr, " lpsdisp\n");\
fprintf(stderr, "	[\n");\
fprintf(stderr, "	-Edon't erase (erase)\n");\
fprintf(stderr, "	-Fmax_freq_displayed (R/2)\n");\
fprintf(stderr, "	-Hdispay_vertical_lines (off)\n");\
fprintf(stderr, "	-Idispay_time_increment (.0025)\n");\
fprintf(stderr, "	-Ldisplay in lower half screen\n");\
fprintf(stderr, "	-Mmultiple display flag (off)\n");\
fprintf(stderr, "	-Ndon't open display\n");\
fprintf(stderr, "	-Rsample_rate (16K)\n");\
fprintf(stderr, "	-Tmin_amp_thresh_displayed(dB) (-78)\n");\
fprintf(stderr, "	-Udisplay in upper half screen\n");\
fprintf(stderr, "	-Vdispay_horizontal_lines (off)\n");\
fprintf(stderr, "	-Wfft_length (1K)\n");\
fprintf(stderr, "	-Xx_tick_every (1000.)\n");\
fprintf(stderr, "	-Yy_tick_every (6.)\n");\
fprintf(stderr, "	]\n");\
fprintf(stderr, "		< floatsams\n");\
exit(-1);\
}

double rate = 16.*1024.;

/* current screen coordinates */
double sxmin= 0., sxmax= 1., 
      symin= 0., symax= 1.;
/* locate current window within screen coordinates */
double wxmin = 1./16., wxmax = 3./4.,
      wymin = 1./8., wymax = 3./4.;
/* current plot range coordinates */
double rxmin= 0., rxmax= 8.*1024.,
      rymin= -78., rymax= 0.;
double window = WLEN;
double incr = INCR;

/* SDY
char s[100], *sprintf();
*/
char s[100];
int mflag = 0, eflag = 1;

main(argc, argv) int argc; char *argv[];
{
 double x, sum, input;
 float *buf, *abuf, *fbuf;
 double t = 0., starttime = 0.;
 double xevery = 1000., yevery = 6.;
 double lastdx, lastdi, tick = .001;
 int scount, average = 1, fset = 0, samps = 0, nopen=0;
 int npeaks, i, n, horiz, vert, data = 1;

    if(isatty(0))USAGE;
    for(i = 1; i < argc; i++){
	if(*argv[i] != '-')USAGE;
	switch(*(++argv[i])){
	    case 'F': fset = 1; rxmax = expr(++argv[i]); break;
	    case 'E': eflag = 0; break;
	    case 'H': horiz = 1; break;
	    case 'I': incr = expr(++argv[i]); break;
	    case 'L': wymin = 1./16., wymax = 7./16.; break;
	    case 'N': nopen = 1; break;
	    case 'M': mflag = 1; break;
	    case 'R': rate = expr(++argv[i]); break;
	    case 'T': rymin = expr(++argv[i]); break;
	    case 'U': wymin = 9./16., wymax = 15./16.; break;
	    case 'V': vert = 1; break;
	    case 'W': window = expr(++argv[i])/2.; break;
	    case 'X': xevery = expr(++argv[i]); break;
	    case 'Y': yevery = expr(++argv[i]); break;
	}
    }
    if(rxmax > rate/2.)rxmax = rate/2.;
    if(!fset && rxmax < rate/2.)rxmax = rate/2.;
    x = 0.0;
    n = 0;
    buf = (float *) calloc( (int) window, sizeof(float));
    abuf = (float *) calloc( (int) window, sizeof(float));
    fbuf = (float *) calloc( (int) window, sizeof(float));
    if(!nopen)openpl();
    if(eflag)erase();
    grid(0.0,rxmax,xevery,"(kHz)",rymin,rymax,yevery,"(dB)");
    while(data){
	for(i=0; i<window; i++){if(!(data=getfloat(buf+i)))break;}
	    logarate(buf, (int) window);
	    npeaks = peakpick(buf, (int) window, abuf, fbuf);
	    for(i=0; i<npeaks; i++){
		if( *(abuf+i) < rymin)continue;
		if( *(fbuf+i) > rxmax)continue;
		if(horiz)
		 line(wx(wxmin),py(*(abuf+i)),px(*(fbuf+i)),py(*(abuf+i)));
		if(vert)
		 line(px(*(fbuf+i)),wy(wymin),px(*(fbuf+i)),py(*(abuf+i)));
		point(px( *(fbuf+i)), py( *(abuf+i)) );
		circle(px( *(fbuf+i)), py( *(abuf+i)), 1 );
		if(!eflag)circle(px( *(fbuf+i)), py( *(abuf+i)), 2 );
	    }
	    wxmin += incr;
	    wxmax += incr;
	    wymin += incr;
	    wymax += incr;
    }
    move(wx(wxmin),wy(wymin)-24);
    closepl();
}
/*
 * peakpick picks out local maxima from log power spectrum in x, and puts
 * them into peak, with the corresponding frequency in the corresponding
 * location of loc
 */
peakpick(x, len, peak, loc) float x[], peak[], loc[]; int len; {
 int cnt=0, i;
    for(i=1; i<len-1; i++){
	if(x[i]>x[i-1] && x[i]>x[i+1]){
	    peak[cnt] = x[i];
	    loc[cnt++] = rate*i/(2.*len);
	}
    }
    return(cnt);
}
logarate(array, len) float array[]; int len;{
 int i;
for(i=0; i<len; i++)if (array[i] > 0.)array[i] = 20.*log10((double)array[i]);
     else array[i] = -120.;
}
windowbox(){
    move(wx(wxmin),wy(wymin));
    cont(wx(wxmax),wy(wymin));
    cont(wx(wxmax),wy(wymax));
    cont(wx(wxmin),wy(wymax));
    cont(wx(wxmin),wy(wymin));
}

grid(fmin,fmax,fmarkevery,xlabel,ymin,ymax,ymarkevery,ylabel)
 double fmin, fmax, fmarkevery, ymin, ymax, ymarkevery;
 char *xlabel, *ylabel;
{
 int j;
 double i, winc;
 double interp();
    for(winc=0.,j=0; j<50; j++)winc += incr;
    move(wx(wxmin),wy(wymin));
    cont(wx(wxmax),wy(wymin));
    move(wx(wxmin),wy(wymin));
    cont(wx(wxmin),wy(wymax));
    for(i = ymin; i <= ymax; i += ymarkevery){
	move(wx(wxmin)-10,py(i));
	cont(wx(wxmin),py(i));
	if(mflag)cont(wx(wxmin)+wx(winc),py(i)+wy(winc));
	move(sx(sxmin),py(i)+6);
	sprintf(s,"%.0f", (float) i);
	label(s);
	sprintf(s,"%.0f", (float) i);
	label(s);
    }
    move(sx(sxmin), py(ymax)+30);
    label(ylabel);

    for(i = fmin; i <= fmax; i += fmarkevery){
	move(px(i),wy(wymin)-10);
	sprintf(s,"%.1f", (float) i/1000.);
	label(s);
	move(px(i),wy(wymin)-10);
	cont(px(i),wy(wymin) );
	if(mflag)cont(px(i)+wx(winc),wy(wymin)+wy(winc));
    }
    move(px(fmax)+50, wy(wymin)-10);
    label(xlabel);
}
double interp(x, xmin, xmax, omin, omax) double x, xmin, xmax, omin, omax; {
    return( (x - xmin)*(omax - omin)/(xmax - xmin) + omin );
}
sx(x) double x; { /* screen to absolute */
 double interp();
    return( (int) interp(x, sxmin, sxmax, (double) XMIN, (double) XMAX) );
}
sy(y) double y; { /* screen to absolute */
    return( (int) interp(y, symin, symax, (double) YMIN, (double) YMAX) );
}
wx(x) double x; { /* window to absolute */
    return( sx(interp(x, wxmin, wxmax, wxmin, wxmax) ) );
}
wy(y) double y; { /* window to absolute */
    return( sy(interp(y, wymin, wymax, wymin, wymax) ) );
}
px(x) double x; { /* ranged data to absolute with window within screen */
 double interp();
    return( sx( interp(x, rxmin, rxmax, wxmin, wxmax) ) );
}
py(y) double y; { /* ranged data to absolute with window within screen */
 double interp();
    return( sy( interp(y, rymin, rymax, wymin, wymax) ) );
}
